<?php

class getDataFromWordpress{
    static public function obtener_clave_api_woocommerce() {
        global $wpdb;
        $resultados = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}woocommerce_api_keys" );
    
        if (count($resultados) > 0) {
            $consumerKey = $resultados[0]->consumer_key;
            return substr($consumerKey, -6);
        } else {
            return false;
        }
    }
    
    static public function obtener_dominio() {
        $url = get_site_url(); // Obtiene la URL del sitio
        $parsed_url = parse_url($url); // Analiza la URL y devuelve sus componentes
        $host = $parsed_url['host']; // Obtiene el host de la URL
    
        // Divide el host en partes
        $parts = explode('.', $host);
    
        // Si el host tiene una subdominio (como www), lo elimina
        if (count($parts) === 3) {
            array_shift($parts);
        }
    
        // Obtiene el dominio con y sin extensión
        $dominio_con_extension = implode('.', $parts);
        $dominio_sin_extension = $parts[0];
    
        return array($dominio_con_extension, $dominio_sin_extension);
    }

    static public function obtener_datos_de_la_base_de_datos() {
        global $wpdb;
        $table_name = "{$wpdb->prefix}wairbot";
    
        // Comprueba si la tabla existe
        if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
            // La tabla no existe, devuelve false
            return false;
        }
    
        $resultados = $wpdb->get_results( "SELECT * FROM $table_name");
    
        //enviar url y ck si existen y si existe la tabla, si la tabla no existe o los datos no están en la tabla, devolver false
        if (count($resultados) > 0) {
            return array($resultados[0]->url, $resultados[0]->ck, $resultados[0]->email);
        } else {
            return false;
        }
    }
}