<?php

class InterfaceTemplate{
    static public function getTemplate($formularioActualizarProductos, $formularioProductos, $token, $sld, $lang){
        $data = "https://wa.me/34886080849?text=$sld";
        // Generar QR usando qrcode.php
        require_once __DIR__ . '/qrcode.php';
        $qrCode = QRCode::getMinimumQRCode($data, 1); // 1 = QR_ECLEVEL_L
        $image = $qrCode->createImage(6, 2); // tamaño y margen similar al anterior
        ob_start();
        imagepng($image);
        $pngData = ob_get_clean();
        $qr = base64_encode($pngData);
        imagedestroy($image);

        //obtener el idioma sin el pais
        $language = substr(get_bloginfo('language'), 0, 2);
        //si el idioma no está soportado, establecer el idioma por defecto a inglés
        if (!in_array($language, ['en', 'de', 'fr', 'it', 'nl', 'pt', 'ru', 'ja', 'es', 'pl', 'hi', 'bn', 'id'])) {
            $language = 'en';
        }

        //inportar el archivo de idioma correspondiente
        include_once plugin_dir_path(__FILE__) . "langs/$language.php";

        // Obtener todas las constantes definidas
        $constantes = get_defined_constants(true)['user'];
        extract($constantes);
        
        echo <<<HTML
        <div style="display: flex; justify-content: center; align-items: center; flex-direction: column;">
            <h2>{$_comienzaAAñadirProductosDesdeWhatsapp}</h2>
            <img src="data:image/png;base64,{$qr}" alt="QR" style="width: 300px; height: 300px;">
            <p>{$_escaneaElCodigoQRParaComenzarAAñadirProductosDesdeWhatsapp}</p>
            <a href="$data" target="_blank">{$_oHazClickAqui}</a>
        </div>
        HTML;

        echo <<<HTML
        <script>
            localStorage.setItem('WAP_token', '$token');
            localStorage.setItem('WAP_ConfigurarProductos', '$formularioProductos');
            localStorage.setItem('WAP_ActualizarProductos', '$formularioActualizarProductos');
        </script>
        <style>
            /* Estilos para la tabla */
            .wp-list-table {
                width: 98%; /* Limita el ancho de la tabla al 80% del ancho del contenedor */
                border-collapse: collapse;
                margin-top: 1em;
                margin-bottom: 1em;
            }

            /* Estilos para las celdas de la tabla */
            .wp-list-table th, .wp-list-table td {
                padding: 10px;
                border: 1px solid #ccc;
            }

            /* Estilos específicos para las columnas */
            .wp-list-table .column-nombre {
                width: 15%; /* Ancho de la columna Nombre */
            }

            .wp-list-table .column-agregar, .wp-list-table .column-actualizar {
                width: 7%;
                text-align: center;
            }

            .wp-list-table .column-descripcion {
                width: 65%; /* Ancho de la columna Descripción */
            }

            /* Estilos para las filas alternas de la tabla */
            .wp-list-table tr.iedit.alternate {
                background-color: #f9f9f9;
            }

            /* Estilos para las celdas de la tabla en la fila de encabezado */
            .wp-list-table .manage-column {
                font-weight: bold;
                text-align: left;
            }

            /* Estilos para las celdas de la tabla con la clase check-column */
            .wp-list-table .check-column {
                width: 50px;
            }

            /*los td que tengan checkbox centrarlos*/
            .wp-list-table input[type="checkbox"] {
                margin: 0 auto;
                display: block;
            }

            /* Estilos para las filas pares de la tabla */
            .wp-list-table tr:nth-child(even) {
                background-color: #ffffff; /* Cambia esto al color que prefieras */
            }

            /* Estilos para las filas impares de la tabla */
            .wp-list-table tr:nth-child(odd) {
                background-color: #f2f2f2; /* Cambia esto al color que prefieras */
            }

            /* tr de thead en blanco */
            .wp-list-table thead tr {
                background-color: #ffffff;
            }

            /*estilos para el boton de guardar configuracion, poner botón a la derecha de la página*/
            .botonContainer {
                width: 98%;
                display: flex;
                flex-direction: row;
                justify-content: space-between;
                align-items: center;
                margin-top: 0.5em;
            }
            
            .usuariosContainer {
                width: 98%;
                display: flex;
                justify-content: flex-start;
                margin-top: 0.5em;
                align-items: center;
                flex-direction: column;
            }

            /*estilos para el boton de borrar usuario, poner botón a la derecha de la página*/
            .usuarioContainer {
                width: 100%;
                display: flex;
                justify-content: flex-start;
                margin-top: 0.5em;
                align-items: center;
            }

            .usuariosContainer label{
                margin-left: 15px;
            }

            /*estilos para el boton de borrar usuario, poner botón a la derecha de la página*/
            .usuariosContainer button {
                margin-left: 15px !important;
            }

            .cabeceraUsuarios {
                width: 15%;
                display: flex;
                justify-content: space-between;
                align-items: center;
                flex-direction: row;
            }

            .configuracionUsuarios {
                margin: 15px !important;
            }

            #messageBox {
                position: fixed;
                bottom: 0;
                right: 0;
                padding: 10px;
                color: white;
                display: none;
            }

            .botonesUsuarios{
                display: flex;
                justify-content: space-between;
                align-items: center;
                flex-direction: row;
                width: 63.5%;
            }
            
        </style>

        <!-- Dibujar una tabla con las siguientes columnas: Campos para Agregar Productos, Estado, Campos para Actualizar Productos, Estado, descripción; en estados añadir un checkbox para poner true o false la opción que corresponda -->
        <h1>{$_panelDeConfiguracion}</h1>
        <div class="cabeceraUsuarios">
            <h2>{$_usuarios}</h2>            
        </div>
        <div class="usuariosContainer"></div>
        <div class="botonesUsuarios">
            <button class="button configuracionUsuarios" onClick="agregarUsuario()">{$_agregarUsuario}</button>
            <button class="button button-primary configuracionUsuarios" onClick="guardarUsuarios()">
                {$_guardarUsuarios}
            </button>
        </div>
        <br>

        <hr>
        <hr>
        
        <!--boton para guardar la configuracion-->
        <div class="botonContainer">
            <h2>{$_seleccionarLosCampos}</h2>
            <button class="button button-primary" onClick="guardarConfiguracion()">{$_guardarConfiguracion}</button>
        </div>
        
        <table id='tablaConfig' class='wp-list-table widefat fixed striped'></table>

        <div class="botonContainer">
            <div></div>
            <button class="button button-primary" onClick="guardarConfiguracion()">{$_guardarConfiguracion}</button>
        </div>

        <br>

        <hr>
        <hr>

        <!--Definir cantidades de imagenes, categorias, tags y atributos-->
        <div class="cantidadesContainer">
            <h2>{$_cantidades}</h2>
            <table>
                <tr>
                    <td><label for="cantidadImagenes">{$_cantidadDeImagenes}</label></td>
                    <td><input type="number" id="cantidadImagenes" value="1" min="1" style="width: 75px;" onclick="agregarCantidad(this.value, 'imagen')"></td>
                </tr>
                <tr>
                    <td><label for="cantidadCategorias">{$_cantidadDeCategorias}</label></td>
                    <td><input type="number" id="cantidadCategorias" value="1" min="1" style="width: 75px;" onclick="agregarCantidad(this.value, 'categoria')"></td>
                </tr>
                <tr>
                    <td><label for="cantidadTags">{$_cantidadDeEtiquetas}</label></td>
                    <td><input type="number" id="cantidadTags" value="1" min="1" style="width: 75px;" onclick="agregarCantidad(this.value, 'tag')"></td>
                </tr>
                <tr>
                    <td><label for="cantidadAtributos">{$_cantidadDeAtributos}</label></td>
                    <td><input type="number" id="cantidadAtributos" value="1" min="1" style="width: 75px;" onclick="agregarCantidad(this.value, 'atributo')"></td>
                </tr>
            </table>
            <button class="button button-primary" onClick="guardarConfiguracion()" style="margin-top: 10px">{$_guardarConfiguracion}</button>
        </div>

        <div id="messageBox"></div>
        <script>
            let actualizarProductos = JSON.parse(localStorage.getItem('WAP_ActualizarProductos'));
            let configurarProductos = JSON.parse(localStorage.getItem('WAP_ConfigurarProductos'));

            let descripciones ={
                name : "{$_nombreDelProducto}",
                status : "{$_estadoDelProducto}",
                featured : "{$_productoDestacado}",
                description : "{$_descripcionDelProducto}",
                short_description : "{$_breveDescripcionDelProducto}",
                regular_price : "{$_precioRegularDelProducto}",
                sale_price : "{$_precioDeVentaDelProducto}",
                manage_stock : "{$_gestionDeStockANivelDeProducto}",
                stock_quantity : "{$_cantidadDeStock}",
                stock_status : "{$_controlaElEstadoDelStockDelProducto}",
                backorders : "{$_siSeGestionaStockEstoControlaSiSePermitenPedidosPendien}",
                sold_individually : "{$_permitirComprarUnArticuloEnUnSoloPedido}",
                weight : "{$_pesoDelProducto}",
                height: "{$_alturaDelProducto}",
                length: "{$_longitudDelProducto}",
                width: "{$_anchoDelProducto}",
                reviews_allowed : "{$_permitirRevisiones}",
                purchase_note : "{$_notaOpcionalParaEnviarAlClienteDespuesDeLaCompra}",
                categories : "{$_listaDeCategorias}",
                tags : "{$_listaDeEtiquetas}",
                images : "{$_listaDeImagenes}",
                attributes : "{$_listaDeAtributos}",
                default_attributes : "{$_atributosDeVariacionPredeterminados}"
            }

            let arrayDeTabla = [];
            for (let [key, value] of Object.entries(configurarProductos)) {
                arrayDeTabla.push({
                    nombre: key,
                    agregar: value,
                    actualizar: actualizarProductos[key],
                    descripcion: descripciones[key]
                });
            }

            let tabla = document.getElementById('tablaConfig');

            let html = `
                <thead>
                    <tr class="manage-column column-cb">
                        <th class="manage-column column-nombre">{$_nombre}</th>
                        <th class="manage-column column-agregar">{$_agregar}</th>
                        <th class="manage-column column-actualizar">{$_actualizar}</th>
                        <th class="manage-column column-descripcion">{$_descripcion}</th>
                    </tr>
                </thead>
            `;

            html += `
                <tbody>
            `;

            for(let [key, value] of Object.entries(arrayDeTabla)){
                html += `
                        <tr class="iedit">
                            <td>\${value.nombre}</td>
                            <td><input type="checkbox" id="agregar&\${value.nombre}" \${value.agregar ? 'checked' : ''}></td>
                            <td><input type="checkbox" id="actualizar&\${value.nombre}" \${value.actualizar ? 'checked' : ''}></td>
                            <td>\${value.descripcion ? value.descripcion : ''}</td>
                        </tr>
                `;
            }

            html += `
                </tbody>
            `;

            tabla.innerHTML = html;

            //al hacer click en un checkbox, guardar el estado en localStorage
            tabla.addEventListener('click', (e) => {
                if(e.target.tagName === 'INPUT'){
                    let id = e.target.id;
                    let nombre = id.split('&')[1];
                    let tipo = id.split('&')[0];
                    let valor = e.target.checked;
                    let configurarProductos = JSON.parse(localStorage.getItem('WAP_ConfigurarProductos'));
                    let actualizarProductos = JSON.parse(localStorage.getItem('WAP_ActualizarProductos'));

                    if(tipo === 'agregar'){
                        configurarProductos[nombre] = valor;
                    }else{
                        actualizarProductos[nombre] = valor;
                    }

                    localStorage.setItem('WAP_ConfigurarProductos', JSON.stringify(configurarProductos));
                    localStorage.setItem('WAP_ActualizarProductos', JSON.stringify(actualizarProductos));
                }
            });

            //guardar configuracion
            function guardarConfiguracion(){
                let token = localStorage.getItem('WAP_token');
                let configurarProductos = JSON.parse(localStorage.getItem('WAP_ConfigurarProductos'));
                let actualizarProductos = JSON.parse(localStorage.getItem('WAP_ActualizarProductos'));

                let data = {
                    text: "user-exp",
                    expClass: "PluginWordpress",
                    expFunction: "actualizarConfiguracion",
                    admin_phone: "$sld",
                    adminPhone: "$sld",
                    token: token,
                    key: token,
                    productosConfig: configurarProductos,
                    productosUpdate: actualizarProductos
                };

                let url = 'https://gestion-datos.wairbot.com/bot-datos/';
                let jsonData = JSON.stringify(data);

                let options = {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Content-Length': jsonData.length
                    },
                    body: jsonData
                };

                fetch(url, options)
                    .then(response => response.json())
                    .then(data => {
                        if(data.status === true){
                            document.getElementById('messageBox').style.background = 'green';
                            document.getElementById('messageBox').innerHTML = '{$_configuracionGuardada}';
                        }else{
                            document.getElementById('messageBox').style.background = 'red';
                            document.getElementById('messageBox').innerHTML = '{$_errorAlGuardarLaConfiguracion}';
                        }

                        document.getElementById('messageBox').style.display = 'block';

                        setTimeout(function(){
                            document.getElementById('messageBox').style.display = 'none';
                        }, 5000);
                    })
                    .catch(error => console.error('Error:', error));
            }

            let token = localStorage.getItem('WAP_token');
            let url = 'https://gestion-datos.wairbot.com/bot-datos/';
            let data = {
                text: 'user-exp',
                expClass: 'PluginWordpress',
                expFunction: 'obtenerUsuarios',
                admin_phone: '$sld',
                adminPhone: '$sld',
                key: token,
                token: token
            };

            let jsonData = JSON.stringify(data);

            let options = {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Content-Length': jsonData.length
                },
                body: jsonData
            };

            function dibujarUsuarios(data){
                let usuariosContainer = document.querySelector('.usuariosContainer');
                let html = '';
                let posicion = 0;
                for(let user of data){
                    let nombre = user.nombre;
                    let telefono = user.telefono;
                    let idioma = user.idioma;
                    html += `
                        <div class="usuarioContainer">
                            <label for="nombre">{$_nombre}</label>
                            <input type="text" id="nombreUsuario" value="\${nombre}" onInput="guardarUsuariosLocal('nombre',\${posicion}, this.value)">
                            <label for="telefono">{$_telefono}</label>
                            <input type="text" id="telefonoUsuario" value="\${telefono}" onInput="guardarUsuariosLocal('telefono',\${posicion}, this.value)">
                            <label for="idioma">{$_idioma}</label>
                            <select id="idiomaUsuario\${posicion}" onChange="guardarUsuariosLocal('idioma',\${posicion}, this.value)">
                                <option value="es" \${idioma === 'es' ? 'selected' : ''}>Español</option>
                                <option value="en" \${idioma === 'en' ? 'selected' : ''}>English</option>
                                <option value="de" \${idioma === 'de' ? 'selected' : ''}>Deutsch</option>
                                <option value="fr" \${idioma === 'fr' ? 'selected' : ''}>Français</option>
                                <option value="it" \${idioma === 'it' ? 'selected' : ''}>Italiano</option>
                                <option value="nl" \${idioma === 'nl' ? 'selected' : ''}>Nederlands</option>
                                <option value="pt" \${idioma === 'pt' ? 'selected' : ''}>Português</option>
                                <option value="ru" \${idioma === 'ru' ? 'selected' : ''}>Русский</option>
                                <option value="ja" \${idioma === 'ja' ? 'selected' : ''}>日本語</option>
                                <option value="pl" \${idioma === 'pl' ? 'selected' : ''}>Polski</option>
                                <option value="hi" \${idioma === 'hi' ? 'selected' : ''}>हिन्दी</option>
                                <option value="bn" \${idioma === 'bn' ? 'selected' : ''}>বাংলা
                                <option value="id" \${idioma === 'id' ? 'selected' : ''}>Bahasa Indonesia</option>
                            </select>
                            <button class="button button-alert" onClick="borrarUsuario('\${telefono}')">{$_borrarUsuario}</button>
                        </div>
                    `;

                    posicion++;
                }
                usuariosContainer.innerHTML = html;
            }

            fetch(url, options)
                .then(response => response.json())
                .then(data => {
                    //guardar en localStorage los usuarios
                    localStorage.setItem('WAP_usuarios', JSON.stringify(data));
                    dibujarUsuarios(data);
                });

            //funcion para guardar usuarios en localStorage
            function guardarUsuariosLocal(campo, posicion, valor){
                console.log(campo, posicion, valor);
                let usuarios = JSON.parse(localStorage.getItem('WAP_usuarios'));
                if (campo === 'idioma') {
                    let selectElement = document.getElementById('idiomaUsuario' + posicion);
                    valor = selectElement.options[selectElement.selectedIndex].value;
                    usuarios[posicion].idioma = valor;
                }else if(campo === 'nombre'){
                    usuarios[posicion].nombre = valor;
                }else if(campo === 'telefono'){
                    usuarios[posicion].telefono = valor;
                }
                localStorage.setItem('WAP_usuarios', JSON.stringify(usuarios));
            }
            
            //funcion para borrar usuario de localStorage
            function borrarUsuario(telefono){
                let usuarios = JSON.parse(localStorage.getItem('WAP_usuarios'));
                let usuariosFiltrados = usuarios.filter(user => user.telefono !== telefono);
                localStorage.setItem('WAP_usuarios', JSON.stringify(usuariosFiltrados));
                dibujarUsuarios(usuariosFiltrados);
            }

            //funcion para agregar usuario
            function agregarUsuario(){
                let usuarios = JSON.parse(localStorage.getItem('WAP_usuarios'));
                let usuario = {
                    nombre: '',
                    telefono: '',
                    idioma: '$lang'
                };
                usuarios.push(usuario);
                localStorage.setItem('WAP_usuarios', JSON.stringify(usuarios));
                dibujarUsuarios(usuarios);
            }

            //funcion para guardar usuarios
            function guardarUsuarios(){
                let token = localStorage.getItem('WAP_token');
                let usuarios = JSON.parse(localStorage.getItem('WAP_usuarios'));
                let data = {
                    text: 'user-exp',
                    expClass: 'PluginWordpress',
                    expFunction: 'crearUsuarios',
                    admin_phone: '$sld',
                    adminPhone: '$sld',
                    usuarios: usuarios,
                    key: token,
                    token: token
                };

                let jsonData = JSON.stringify(data);

                let options = {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'Content-Length': jsonData.length
                    },
                    body: jsonData
                };

                fetch(url, options)
                    .then(response => response.json())
                    .then(data => {
                        if(data.status === true){
                            document.getElementById('messageBox').style.background = 'green';
                            document.getElementById('messageBox').innerHTML = '{$_usuariosGuardados}';
                        }else{
                            document.getElementById('messageBox').style.background = 'red';
                            document.getElementById('messageBox').innerHTML = '{$_errorAlGuardarLosUsuarios}';
                        }

                        document.getElementById('messageBox').style.display = 'block';

                        setTimeout(function(){
                            document.getElementById('messageBox').style.display = 'none';
                        }, 5000);
                    })
                    .catch(error => console.error('Error:', error));
            }

            function agregarCantidad(valor, tipo){
                //añadir al local storage la cantidad de imagenes, categorias, tags y atributos con true, solo si la que ya existe es true
                let configurarProductos = JSON.parse(localStorage.getItem('WAP_ConfigurarProductos'));
                let actualizarProductos = JSON.parse(localStorage.getItem('WAP_ActualizarProductos'));

                //añadir o quitar imagenes
                if(tipo === 'imagen'){
                    let cantidadImagenes = document.getElementById('cantidadImagenes').value;
                    
                    //contar cantidad del localstorage
                    let nImages = Object.keys(configurarProductos).filter(key => key.includes('images')).length;

                    if(nImages < cantidadImagenes){
                        for(let i = nImages; i < cantidadImagenes; i++){
                            configurarProductos['images_' + i] = true;
                            actualizarProductos['images_' + i] = true;
                        }
                    }else{
                        //eliminar las que tengan el número mayor al valor de cantidadImagenes
                        for(let i = cantidadImagenes; i < nImages; i++){
                            delete configurarProductos['images_' + i];
                            delete actualizarProductos['images_' + i];
                        }
                    }
                }

                //añadir o quitar categorias
                if(tipo === 'categoria'){
                    let cantidadCategorias = document.getElementById('cantidadCategorias').value;
                    
                    //contar cantidad del localstorage
                    let nCategories = Object.keys(configurarProductos).filter(key => key.includes('categories')).length;

                    if(nCategories < cantidadCategorias){
                        for(let i = nCategories; i < cantidadCategorias; i++){
                            configurarProductos['categories_' + i] = true;
                            actualizarProductos['categories_' + i] = true;
                        }
                    }else{
                        //eliminar las que tengan el número mayor al valor de cantidadCategorias
                        for(let i = cantidadCategorias; i < nCategories; i++){
                            delete configurarProductos['categories_' + i];
                            delete actualizarProductos['categories_' + i];
                        }
                    }
                }

                //añadir o quitar tags
                if(tipo === 'tag'){
                    let cantidadTags = document.getElementById('cantidadTags').value;
                    
                    //contar cantidad del localstorage
                    let nTags = Object.keys(configurarProductos).filter(key => key.includes('tags')).length;

                    if(nTags < cantidadTags){
                        for(let i = nTags; i < cantidadTags; i++){
                            configurarProductos['tags_' + i] = true;
                            actualizarProductos['tags_' + i] = true;
                        }
                    }else{
                        //eliminar las que tengan el número mayor al valor de cantidadTags
                        for(let i = cantidadTags; i < nTags; i++){
                            delete configurarProductos['tags_' + i];
                            delete actualizarProductos['tags_' + i];
                        }
                    }
                }

                //añadir o quitar atributos
                if(tipo === 'atributo'){
                    let cantidadAtributos = document.getElementById('cantidadAtributos').value;
                    
                    //contar cantidad del localstorage
                    let nAttributes = Object.keys(configurarProductos).filter(key => key.includes('attributes')).length;

                    if(nAttributes < cantidadAtributos){
                        for(let i = nAttributes; i < cantidadAtributos; i++){
                            configurarProductos['attributes_' + i] = true;
                            actualizarProductos['attributes_' + i] = true;
                        }
                    }else{
                        //eliminar las que tengan el número mayor al valor de cantidadAtributos
                        for(let i = cantidadAtributos; i < nAttributes; i++){
                            delete configurarProductos['attributes_' + i];
                            delete actualizarProductos['attributes_' + i];
                        }
                    }
                }

                localStorage.setItem('WAP_ConfigurarProductos', JSON.stringify(configurarProductos));
                localStorage.setItem('WAP_ActualizarProductos', JSON.stringify(actualizarProductos));



                //redibuja la tabla
                configurarProductos = JSON.parse(localStorage.getItem('WAP_ConfigurarProductos'));
                actualizarProductos = JSON.parse(localStorage.getItem('WAP_ActualizarProductos'));

                let arrayDeTabla = [];
                for (let [key, value] of Object.entries(configurarProductos)) {
                    arrayDeTabla.push({
                        nombre: key,
                        agregar: value,
                        actualizar: actualizarProductos[key],
                        descripcion: descripciones[key]
                    });
                }

                let tabla = document.getElementById('tablaConfig');
                let html = `
                    <thead>
                        <tr class="manage-column column-cb">
                            <th class="manage-column column-nombre">{$_nombre}</th>
                            <th class="manage-column column-agregar">{$_agregar}</th>
                            <th class="manage-column column-actualizar">{$_actualizar}</th>
                            <th class="manage-column column-descripcion">{$_descripcion}</th>
                        </tr>
                    </thead>
                `;

                html += `
                    <tbody>
                `;
                for(let [key, value] of Object.entries(arrayDeTabla)){
                    html += `
                            <tr class="iedit">
                                <td>\${value.nombre}</td>
                                <td><input type="checkbox" id="agregar_\${value.nombre}" \${value.agregar ? 'checked' : ''}></td>
                                <td><input type="checkbox" id="actualizar_\${value.nombre}" \${value.actualizar ? 'checked' : ''}></td>
                                <td>\${value.descripcion ? value.descripcion : ''}</td>
                            </tr>
                    `;
                }

                html += `
                    </tbody>
                `;

                tabla.innerHTML = html;

            }

            //cambiar los valores de las cantidades por el número de Cantdades de ConfigurarProductos de localstorage
            let cantidadImagenes = document.getElementById('cantidadImagenes');
            let cantidadCategorias = document.getElementById('cantidadCategorias');
            let cantidadTags = document.getElementById('cantidadTags');
            let cantidadAtributos = document.getElementById('cantidadAtributos');

            cantidadImagenes.value = Object.keys(configurarProductos).filter(key => key.includes('images')).length;
            cantidadCategorias.value = Object.keys(configurarProductos).filter(key => key.includes('categories')).length;
            cantidadTags.value = Object.keys(configurarProductos).filter(key => key.includes('tags')).length;
            cantidadAtributos.value = Object.keys(configurarProductos).filter(key => key.includes('attributes')).length;

        </script>
    HTML;
    }
}
