<?php

class RegisterTemplate{
    static public function printTemplate($woocommerce_api_settings_link, $dominio_con_extension, $dominio_sin_extension, $lang, $wordpressEmail){

        //obtener el idioma sin el pais
        $language = substr(get_bloginfo('language'), 0, 2);
        //si el idioma no está soportado, establecer el idioma por defecto a inglés
        if (!in_array($language, ['en', 'de', 'fr', 'it', 'nl', 'pt', 'ru', 'ja', 'es', 'pl', 'hi', 'bn', 'id'])) {
            $language = 'en';
        }

        //inportar el archivo de idioma correspondiente
        require_once plugin_dir_path(__FILE__) . "langs/$language.php";

        // Obtener todas las constantes definidas
        $constantes = get_defined_constants(true)['user'];
        extract($constantes);   

        echo <<<HTML
        <!--Aceptar condiciones-->
        <div id='textTerms'>
            <h2>{$_paso1De4LeeYAceptaLasCondiciones}</h2>
            <div class='notice notice-info' style='margin:0px 0px 10px 0px; width: 30%;'>
                <h3>{$_necesitamosTuPermisoParaObtenerLaClaveDeWooCommerceParaUtilizarEstePlugin}</h3>
                <p>{$_laAPIRestDeWoocommerceSonUnConjuntoDeFuncionalidadesQueProporcionaWoocommerParaAccederYEscribirDatosDeTuEcommerce}</p>
                <p>{$_guardaremosTuClaveParaPoderAccederAEllaEnUnServidorSeguroPropiedadDeWairbotYCodificadaParaImpedirLaLectura}</p>
                <p>{$_enNingunCasoEstosCodigosSeranSuministradosLeidosOBendidosPorTerceros}</p>
                <p>{$_podrasRevocarElAccesoATuClaveEnCualquierMomentoDesdeTuPanelDeAjustesDeWoocommerce}</p>
                <p>{$_estaClaveSoloSeUtilizaraParaLosFinesDescritosDelPlugin}</p>
                <p>{$_wairbotNoSeResponsabilizaDeLasConsecuenciasDeAtaquesMaliciososQuePuedanObtenerDichosCodigosYHacerUnUsoIlícitoDeEllos}</p>
                <p>{$_whatscommerceRequiereUnServicioDeSuscripcionASuApiDe}/{$_mes} <br>
                    {$_puedesSaberMas} <a href="https://whatscommerce.pro/terms/">{$_aqui}</a>
                </p>
            </div>
        </div>
        <input type='checkbox' id='terms'><span id='textAceptarTerminios'>{$_aceptoLosTerminosYCondiciones}</span>
        <button id='configButton' class='button button-primary' style='display:none; margin-top: 20px; margin-bottom: 10px'>
            {$_configurarClaveDeWooCommerce}
        </button>

        <!--Configurar Permisos-->
        <div id='textInstructions' style='display:none;'>
            <h2>{$_paso2De4ConfigurarPermisosDeAPIRestDeWoocommerce}</h2>
            <p>{$_laVentanaQueSeMuestraAContinuacionEsUnAccesoALaPaginaDeConfiguracionDeWoocoomerceEnElApartadoAvanzadoYEnLaSeccionAPIREST}</p>
            <ul>
                <li>1.- {$_completaElCampoDESCRIPCIONPorEjemploWairbot}</li>
                <li>2.- {$_seleccionarUnUsuarioPuedesSeleccionarCualquierUsuarioConPermisosDeAdministradorEnLaMayoriaDeLosCasosElUsuarioQueSalePorDefectoEsValido}</li>
                <li>3.- {$_seleccionarPermisosEsMuyImportanteSeleccionarLECTURAESCRITURA}</li>
                <li>4.- {$_unaVezCompletadoElFormularioPulsaElBotonGenerarClaveDeAPI}</li>
            </ul>
        </div>
        <div class="spinner is-active" style='display:none; float:none; width:100%;'>
            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;{$_abriendoMenuWooCommerceAjustesAvanzadoAPIREST}
        </div>
        <div id='configIframe' style="width:100%; height:500px; display:none;">
            <iframe src="$woocommerce_api_settings_link" style="width:70%; height:100%; border: 1px solid black;"></iframe>
        </div>

        <!--Enviar datos-->
        <div id='textSendData' style='display:none;'>
            <h2>{$_paso3De4EnviarDatosAWairbot}</h2>
            <h4>{$_seHanObtenidoLosSiguentesDatos}</h4>
            <ul style='background-color: #f0f0f0; padding: 10px;'>
                <li><b>{$_consumerKeyDeWoocommerce}</b> <span id='consumerKey'></span></li>
                <li><b>{$_consumerSecretDeWoocommerce}</b> <span id='consumerSecret'></span></li>
                <li><b>{$_URLDeTuTienda}</b> $dominio_con_extension</li>
                <li>
                    <label for="email">Email</label>
                    <input type='email' name="email" id='email' value='$wordpressEmail' style='margin-bottom: 10px; width: 250px;'>
                </li>
            </ul>
            <div class='notice notice-info' style='margin:0px 0px 10px 0px; width: 30%;'>
                <h3>{$_leeDetenidamenteEstaInformacionAntesDePulsarEnEnviar}</h3>
                <ul>
                    <li>{$_estosDatosSeEnviaranaWairbotParaPoderUtilizarElPlugin}</li>
                    <li>{$_noVolveraAMostrarseEstosDatosDeAccesoUnaVezEnviesLosDatosWairbotNoTendraAccesoATuClaveSecretaDeWoocommerceSinCodificar}</li>
                    <li>{$_seGuradaraConsumerKeyEnTuBaseDeDatosDeWordpressParaUsarlaEnCadaConsultaComoComprobanteDeIdentidad}</li>
                </ul>
            </div>
        </div>

        <!--Prefijo Telefónico-->
        <div id='textPrefix' style='display:none;'>
            <h2>{$_introduceTuTelefonoConWhatsapp}</h2>
            <label for="prefix">{$_introduceElPrefijoTelefonicoDeTuPaisSinSimboloONi00}</label><br>
            <input type='number' name="prefix" id='prefix' placeholder='{$_introduceElPrefijoTelefonicoDeTuPaisSinSimboloONi00}' style='margin-bottom: 10px; width: 250px;'>
            <br>
            <label for="phoneNumber">{$_numeroDeTelefonoConPrefijo}</label><br>
            <input type='number' name="phoneNumber" id='phoneNumber' placeholder='{$_numeroDeTelefonoConPrefijo}' style='margin-bottom: 10px;  width: 250px;'>
            <br>
            <small>{$_puedesInformarteSobrePrefijosTelefonicosCompatiblesConWhatsappAqui}
                <a href="https://faq.whatsapp.com/640432094208718/">Whatsapp Help</a>
            </small>
            <!--Menaje de error-->
            <div id='errorPhone' style='display:none; color:red; margin-top: 10px;'></div>
        </div>

        <button id='sendDataButton' class='button button-primary' style='display:none; margin-top: 20px; margin-bottom: 10px'>
            {$_enviarDatosAWairbot}
        </button>
        

        <script>
            document.getElementById('terms').addEventListener('change', function() {
                if(this.checked) {
                    document.getElementById('configButton').style.display = 'block';
                } else {
                    document.getElementById('configButton').style.display = 'none';
                }
            });
        
            document.getElementById('configButton').addEventListener('click', function() {
                document.getElementById('textInstructions').style.display = 'block';
                document.querySelector('.spinner').style.display = 'block';

                //ocultar el texto, el checkbox y el botón
                document.getElementById('textTerms').style.display = 'none';
                document.getElementById('terms').style.display = 'none';
                document.getElementById('configButton').style.display = 'none';
                document.getElementById('textAceptarTerminios').style.display = 'none';

                //buscar cada 1 segundo si existe dentro del iframe el botón con el texto "Añadir Clave" y si existe, hacer click
                let intervalId = setInterval(() => {
                    let iframe = document.querySelector('iframe');
                    let iframeDocument = iframe.contentDocument || iframe.contentWindow.document;
                    let addKeyButton = iframeDocument.querySelector('a.page-title-action');
                    //si existe el botón, hacer click y detener el intervalo
                    console.log(addKeyButton);
                    if(addKeyButton) {
                        addKeyButton.click();
                        clearInterval(intervalId);
                    }
                }, 1000);

                //buscar cada 1 segundos si existe dentro del iframe un input con el id key_description y si existe, escribir "Wairbot"
                let intervalId2 = setInterval(() => {
                    let iframe = document.querySelector('iframe');
                    let iframeDocument = iframe.contentDocument || iframe.contentWindow.document;
                    let descriptionInput = iframeDocument.getElementById('key_description');
                    //si existe el input, escribir "Wairbot" y detener el intervalo
                    if(descriptionInput) {
                        descriptionInput.value = 'Whatscommerce';
                        clearInterval(intervalId2);
                    }
                }, 1000);

                //buscar cada 1 segundos si existe dentro del iframe un select con el id key_permissions y si existe, seleccionar la option "Read/Write"
                let intervalId3 = setInterval(() => {
                    let iframe = document.querySelector('iframe');
                    let iframeDocument = iframe.contentDocument || iframe.contentWindow.document;
                    let permissionsSelect = iframeDocument.getElementById('key_permissions');
                    //si existe el select, seleccionar la option "Read/Write" y detener el intervalo
                    if(permissionsSelect) {
                        permissionsSelect.value = 'read_write';

                        //mostrar el iframe
                        document.getElementById('configIframe').style.display = 'block';

                        //ocultar el spinner
                        document.querySelector('.spinner').style.display = 'none';

                        //bajar el scrol del iframe 200px
                        iframe.contentWindow.scrollBy(0, 200);

                        clearInterval(intervalId3);
                    }
                }, 1000);

                //buscar cada 1 segundos si existe dentro del iframe un input con el id key_consumer_key y si existe, obtener el valor de "key_consumer_key" y "key_consumer_secret"
                let consumerKey = null;
                let consumerSecret = null;
                let intervalId4 = setInterval(() => {
                    let iframe = document.querySelector('iframe');
                    let iframeDocument = iframe.contentDocument || iframe.contentWindow.document;
                    consumerKey = iframeDocument.getElementById('key_consumer_key');
                    consumerSecret = iframeDocument.getElementById('key_consumer_secret');
                    //si existe el input, obtener el valor de "key_consumer_key" y "key_consumer_secret" y detener el intervalo
                    if(consumerKey && consumerSecret) {
                        console.log(consumerKey.value, consumerSecret.value);
                        clearInterval(intervalId4);
                    }
                }, 1000);

                //comprobar cada 1 segundos si consumerKey y consumerSecret son distintos de null, si lo son, mostrar el botón de enviar datos a Wairbot y ocultar el iframe
                let intervalId5 = setInterval(() => {
                    if(consumerKey && consumerSecret) {
                        document.getElementById('consumerKey').innerText = consumerKey.value;
                        document.getElementById('consumerSecret').innerText = consumerSecret.value;
                        //document.getElementById('sendDataButton').style.display = 'block';
                        document.getElementById('configIframe').style.display = 'none';

                        //mostrar el prefijo telefónico
                        document.getElementById('textPrefix').style.display = 'block';

                        //textInstructions textSendData sendDataButton
                        document.getElementById('textInstructions').style.display = 'none';
                        document.getElementById('textSendData').style.display = 'block';

                        clearInterval(intervalId5);
                    }
                }, 1000);

                /*
                 - Al hacer input en el prefijo telefonico y el telefono, comprobar que el telefono contenga el prefijo
                 - Si el telefono no contiene el prefijo, mostrar un mensaje de error
                 - Si el telefono contiene el prefijo y no telfono y prefijo no están vacíos, mostrar el botón de enviar datos a Wairbot
                */
                document.getElementById('prefix').addEventListener('input', function() {
                    let prefix = this.value;
                    let phone = document.getElementById('phoneNumber').value;
                    let errorPhone = document.getElementById('errorPhone');
                    if(phone !== '' && !phone.startsWith(prefix)) {
                        errorPhone.style.display = 'block';
                        errorPhone.innerText = '{$_elTelefonoDebeContenerElPrefijoTelefonico}';
                    } else {
                        errorPhone.style.display = 'none';
                    }
                });

                document.getElementById('phoneNumber').addEventListener('input', function() {
                    let prefix = document.getElementById('prefix').value;
                    let phone = this.value;
                    let errorPhone = document.getElementById('errorPhone');
                    if(phone !== '' && !phone.startsWith(prefix)) {
                        errorPhone.style.display = 'block';
                        errorPhone.innerText = '{$_elTelefonoDebeContenerElPrefijoTelefonico}';
                    } else {
                        errorPhone.style.display = 'none';
                    }
                });

                //mostar el botón de enviar datos a Wairbot si el telefono contiene el prefijo y no están vacíos
                document.getElementById('phoneNumber').addEventListener('input', function() {
                    let prefix = document.getElementById('prefix').value;
                    let phone = this.value;
                    if(phone.startsWith(prefix) && phone !== '' && prefix !== '') {
                        document.getElementById('sendDataButton').style.display = 'block';
                    } else {
                        document.getElementById('sendDataButton').style.display = 'none';
                    }
                });

                document.getElementById('prefix').addEventListener('input', function() {
                    let prefix = this.value;
                    let phone = document.getElementById('phoneNumber').value;
                    if(phone.startsWith(prefix) && phone !== '' && prefix !== '') {
                        document.getElementById('sendDataButton').style.display = 'block';
                    } else {
                        document.getElementById('sendDataButton').style.display = 'none';
                    }
                });

                async function registro(lang, urlCompleta, urlSinExtension, ck, cs, prefix, phoneNumber, email){
                    //obtener las 6 últimas letras del consumer key de woocommerce
                    let consumerKey = ck.substr(-6);

                    //eliminar de urlCompleta lo que esté despues de wp-admin
                    urlCompleta = urlCompleta.split('wp-admin')[0];

                    let datos = {
                        key:"",
                        text: "user-pluginWordpressWairbotAdmin",
                        tipo: "productosAdministrador",
                        email: email,
                        password: urlSinExtension + consumerKey,
                        lang: lang,
                        wooCk: ck,
                        wooCs: cs,
                        wooUrl: urlCompleta,
                        adminPhone: urlSinExtension,
                        prefix: prefix,
                        productosConfig: [],
                        productosUpdate: [],
                        usuarios:[
                            {
                                nombre: "TheAdmin",
                                telefono: phoneNumber,
                                idioma: lang
                            }
                        ]
                    }

                    //let url = 'https://gestion-datos.wairbot.com/bot-datos/';
                    let url = 'https://gestion-datos.wairbot.com/bot-datos/';

                    let response = await fetch(url, {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify(datos)
                    });

                    let result = await response.json();

                    return result;
                }

                //enviar datos a Wairbot
                document.getElementById('sendDataButton').addEventListener('click', async function() {
                    //guarda en la base de datos de wordpress
                    let url = '$dominio_con_extension';
                    let urlSinExtension = '$dominio_sin_extension';
                    let ck = consumerKey.value;
                    let cs = consumerSecret.value;
                    let prefix = document.getElementById('prefix').value;
                    let phoneNumber = document.getElementById('phoneNumber').value;
                    let lang = '$lang';
                    let data = new FormData();
                    let email = document.getElementById('email').value;
                    data.append('url', url);
                    data.append('ck', ck);
                    data.append('email', email);
                    //obtener la url del sitio
                    //eliminar de la url lo que esté después de admin.php, la carpeta anterior y admin.php
                    let urlCompleta = window.location.href;
                    let urlSinAdmin = urlCompleta.split('admin.php')[0];
                    let urlSinCarpetaAnterior = urlSinAdmin.split('/').slice(0, -2).join('/');
                    let url_save_php = urlSinCarpetaAnterior + '/wp-content/plugins/whatscommerce/save.php';
                    console.log(url_save_php);
                    fetch(url_save_php, {
                        method: 'POST',
                        body: data
                    })
                    .then(response => response.text())
                    .then(async (data) => {
                        console.log(data);
                        let resultadoRegistro = await registro(lang, urlCompleta, urlSinExtension, ck, cs, prefix, phoneNumber, email);
                        console.log(resultadoRegistro);
                        //recargar el plugin
                        location.reload();
                    })
                    .catch(error => {
                        console.error('Error:', error);
                    });
                });
            });

        </script>
        HTML;
    }
}