<?php
require_once(dirname(__FILE__) . '/../../../wp-blog-header.php');

// Incluye el archivo wp-load.php para tener acceso a las funciones de WordPress
require_once(ABSPATH . 'wp-load.php');

// Accede a la base de datos global de WordPress
global $wpdb;

// Prepara el nombre de la tabla
$table_name = $wpdb->prefix . 'wairbot';

// Comprueba si la tabla ya existe
if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
    // La tabla no existe, así que la creamos
    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NULL AUTO_INCREMENT,
        url varchar(255) NULL,
        ck varchar(255) NULL,
        email varchar(255) NULL,
        PRIMARY KEY  (id)
    );";

    dbDelta($sql);
}

// Comprueba si se han enviado datos
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Recoge los datos enviados
    $url = $_POST['url'];
    $ck = $_POST['ck'];
    $email = $_POST['email'];

    // Prepara los datos para la inserción
    $data = array(
        'url' => $url,
        'ck' => $ck,
        'email' => $email
    );
    $format = array('%s', '%s', '%s');

    // Inserta los datos en la tabla
    $wpdb->insert($table_name, $data, $format);
    
    // Comprueba si la inserción ha sido exitosa
    if($wpdb->insert_id > 0){
        echo 'Datos guardados correctamente.';
    } else {
        echo 'Ha ocurrido un error al guardar los datos.';
    }
}