<?php
/*
Plugin Name: whatscommerce
Plugin URI: https://whatscommerce.pro
Description: Create products in your Woocommerce store from your WhatsApp, faster, anywhere, from your smartphone.
Version: 1.0
Author: Silicon Valley Vigo
Author URI: http://www.wairbot.com
License: GPL2
*/

//obtener el idioma sin el pais
$language = substr(get_bloginfo('language'), 0, 2);

include_once plugin_dir_path(__FILE__) . "class/getDataFromWordpress.php";
include_once plugin_dir_path(__FILE__) . "class/interfaceTemplate.php";
include_once plugin_dir_path(__FILE__) . "class/registerTemplate.php";
include_once plugin_dir_path(__FILE__) . "class/scriptsJs.php";

//si el idioma no está soportado, establecer el idioma por defecto a inglés
if (!in_array($language, ['en', 'de', 'fr', 'it', 'nl', 'pt', 'ru', 'ja', 'es', 'pl', 'hi', 'bn', 'id'])) {
    $language = 'en';
}

//inportar el archivo de idioma correspondiente
require_once plugin_dir_path(__FILE__) . "class/langs/$language.php";

// Agrega un elemento al menú de administración
add_action('admin_menu', 'wairbot_admin_menu');

#BOTÓN MENÚ#
function wairbot_admin_menu() {
    $icon_url = plugins_url('imgs/icon.png', __FILE__);

    add_menu_page(
        'Whatscommerce', // Título de la página
        'Whatscommerce', // Título del menú
        'manage_options', // Capacidad requerida para acceder
        'whatscommerce-settings', // Slug de la página
        'whatscommerce_settings_page', // Función que renderiza la página
        $icon_url
    );
}

#AVISOS#
//comprobar si el wordpress tiene instalado woocommerce y si no, mostrar un enlace para instalarlo en formato de aviso
add_action('admin_init', function() {
    if (!class_exists('WooCommerce')) {
        add_action('admin_notices', function() {
            // Obtener todas las constantes definidas
            $constantes = get_defined_constants(true)['user'];
            extract($constantes);

            echo <<<HTML
                <div class="notice notice-error is-dismissible">
                    <h2>Whatscommerce</h2>
                    <p>{$_paraPoderUtilizar} <b>Whatscommerce</b>, {$_necesitasInstalar}
                        <a href="'.admin_url('plugin-install.php?s=woocommerce&tab=search&type=term').'" target="_blank">WooCommerce</a>.
                    </p>
                </div>;
            HTML;
        });
    }
});

#SPINER DE CARGA#
function load_custom_wp_admin_style() {
    wp_register_style( 'custom_wp_admin_css', get_template_directory_uri() . '/admin-style.css', false, '1.0.0' );
    wp_enqueue_style( 'custom_wp_admin_css' );
}
add_action( 'admin_enqueue_scripts', 'load_custom_wp_admin_style' );

#PÁGINA#
function whatscommerce_settings_page() {
    if (!class_exists('WooCommerce')) {
        return;
    }

    $whatscommerce = plugins_url('imgs/whatscommerce.svg', __FILE__);
    $svv = plugins_url('imgs/svv.svg', __FILE__);
    $stripe = plugins_url('imgs/stripe.svg', __FILE__);

    //obtener los datos de la base de datos de wordpress
    $userData = getDataFromWordpress::obtener_datos_de_la_base_de_datos();

    //obtener el ck de woocommerce
    list($dominio_con_extension, $dominio_sin_extension) = getDataFromWordpress::obtener_dominio();

    $woocommerce_api_settings_link = admin_url('admin.php?page=wc-settings&tab=advanced&section=keys');

    $lang = substr(get_bloginfo('language'), 0, 2);

    // Obtener todas las constantes definidas
    $constantes = get_defined_constants(true)['user'];
    extract($constantes);
    
        //cabecera
    echo <<<HTML
        <style>
            .headerWordpress {
                width: 98%;
                display: flex;
                justify-content: space-between;
                align-items: center;
                background-color: #f1f1f1;
                padding-top: 10px;
                padding-bottom: 10px;
                margin-bottom: 30px;
                border-bottom: 2px solid #e0e0e0;
            }
            .headerWordpress img {
                width: 180px;
            }
            .headerWordpress div {
                display: flex;
                align-items: center;
            }
            .headerWordpress div img {
                width: 180px;
            }
            .headerWordpress div a {
                margin-left: 20px;
                /*quitar estilos de enlace */
                text-decoration: none;
            }
            .headerWordpress div .dashicons-sos {
                font-size: 30px;
                cursor: pointer;
                margin-right: 10px;
            }
            .headerWordpress div .botonDeAyuda {
                display: flex;
                align-items: center;
                padding: 10px 20px;
                border: 1.5px solid #7f55b3;
                border-radius: 5px;
            }
            .headerWordpress div .botonDeAyuda:hover {
                background-color: #7f55b3;
                color: white;
            }
            
        </style>
        <div class="headerWordpress">
            <a href="https://whatscommerce.pro" target="_blank">
                <img src="$whatscommerce" alt="Whatscommerce" width="180px">
            </a>
            <div>
                <div>
                    <div>{$_unProductoDe}</div>
                    <a href="https://siliconvalleyvigo.com" target="_blank">
                        <img src="$svv" alt="Silicon Valley Vigo" width="180px">
                    </a>
                </div>
                <a href="https://whatscommerce.pro/help/" target="_blank" class="botonDeAyuda">
                    <div class="dashicons dashicons-sos"></div>
                    <div>{$_ayuda}</div>
                </a>
            </div>
        </div>
    HTML;


    if($userData === false) {
        $wordpressEmail = get_option('admin_email');
        RegisterTemplate::printTemplate($woocommerce_api_settings_link, $dominio_con_extension, $dominio_sin_extension, $lang, $wordpressEmail);
    }else{
        //obtener las 6 últimas letras del consumer key de woocommerce
        $consumerKey = substr($userData[1], -6);
        $email = $userData[2];

        $host = parse_url($userData[0], PHP_URL_HOST);
        if ($host === null){
            $host = $userData[0]; 
        }
        $parts = explode('.', $host);
        if(count($parts) === 1){
            $sld = $parts[0];
        }else{
            $sld = $parts[count($parts) - 2];
        }

        $url = 'https://gestion-datos.wairbot.com/bot-datos/';
        $data = [
            'key' => "",
            'text' => 'user-loginMultiple',
            'AD_email_' => $email,
            'AD_password_' => $sld .$consumerKey
        ];

        $jsonData = json_encode($data);

        $options = [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $jsonData,
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/json',
                'Content-Length: ' . strlen($jsonData)
            ]
        ];

        $ch = curl_init();
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            //eliminar la base de datos de wairbot si hay un error
            global $wpdb;
            $table_name = "{$wpdb->prefix}wairbot";
            $wpdb->query("DROP TABLE IF EXISTS $table_name");

            echo 'Error:' . curl_error($ch) . '.' . 'tabla de wairbot eliminada.';
        }

        curl_close($ch);

        $response = json_decode($response, true);
        if ($response['status'] === '400') {
            //eliminar la base de datos de wairbot si hay un error
            global $wpdb;
            $table_name = "{$wpdb->prefix}wairbot";
            $wpdb->query("DROP TABLE IF EXISTS $table_name");

            echo 'Error: ' . $response['message'] . '. ' . 'tabla de wairbot eliminada.';
            exit();
        }

        //si status es 204 soliciar el pago y salir
        if ($response['status'] === '204') {
            //solicitar el pago
            echo <<<HTML
                <style>
                    .enlaceComoBoton {
                        display: inline-block;
                        padding: 10px 20px;
                        margin: 10px 0;
                        background-color: #6772e5;
                        color: white;
                        text-decoration: none;
                        border-radius: 5px;
                        font-weight: bold;
                        font-size: 1.2rem;
                    }

                    .enlacePagoContainer{
                        width: 250px;
                        display: flex;
                        flex-direction: column;
                        align-items: center;
                    }

                </style>

                <h2>{$_paso4De4RealizarElPagoDeSubscripcion}</h2>
                <h3>{$_pagoSeguroYFacturacionConStripe}</h3>
                <div class="enlacePagoContainer">
                    <img src="$stripe" alt="Stripe" width="180px">
                    <a href="https://stripe.com" target="_blank">{$_saberMasDeStripe}</a>
                    <a  href="https://buy.stripe.com/6oE5lD59T7mJ57q28e?prefilled_email=$email" 
                        class="enlaceComoBoton"
                        target="_blank"
                        onclick="comprobarSuscripcion()">
                        {$_suscribete}
                    </a>
                    <h3>21.00 $/{$_mes}</h3>
                    <div class="spinner is-active" style='display:none; float:none;'></div>
                    <div class="mensajeSpinner" style='display:none'>{$_spinner}</div>
                </div>
                <script>
                    function comprobarSuscripcion(){
                        //mostrar el spinner
                        document.querySelector('.spinner').style.display = 'block';
                        document.querySelector('.mensajeSpinner').style.display = 'block';

                        //comprobar cada 3 segundos si el usuario ha pagado
                        setInterval(() => {
                            //comprobar si el usuario ha pagado
                            let url = 'https://gestion-datos.wairbot.com/bot-datos/';
                            let data = {
                                key: "",
                                text: 'user-loginMultiple',
                                AD_email_: '$email',
                                AD_password_: '$sld$consumerKey'
                            };
                            let jsonData = JSON.stringify(data);
                            let options = {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/json',
                                    'Content-Length': jsonData.length
                                },
                                body: jsonData
                            };
                            fetch(url, options)
                                .then(response => response.json())
                                .then(data => {
                                    if (data.status === '200') {
                                        //ocultar el spinner
                                        document.querySelector('.spinner').style.display = 'none';
                                        document.querySelector('.mensajeSpinner').style.display = 'none';

                                        //recargar la página
                                        location.reload();
                                    }
                                });
                        }, 3000);
                    }
                </script>
            HTML;
        }
        
        if ($response['status'] === '200'){
            $token = $response['data'][0]['token'];
            $permisos = json_decode($response['data'][0]['AD_permisos_'], true);
            $datosAuxiliares = $permisos['datosAuxiliares'];
            $formularioProductos = $datosAuxiliares['productosConfig'];
            $formularioActualizarProductos = $datosAuxiliares['productosUpdate'];

            //convertir formularioProductos y formularioActualizarProductos a JSON
            $formularioProductos = json_encode($formularioProductos);
            $formularioActualizarProductos = json_encode($formularioActualizarProductos);

            InterfaceTemplate::getTemplate($formularioActualizarProductos, $formularioProductos, $token, $sld, $lang);
        }
        
    }
}

/*
    en: inglés
    de: alemán
    fr: francés
    it: italiano
    nl: neerlandés
    pt: portugués
    ru: ruso
    ja: japonés
    es: español
    pl: polaco
    hi: hindi
    bn: bengalí
    id: indonesio
*/
